# SQL2DB Migration Tool 업데이트 로그

## 🚀 v0.8.7 - JSON 매핑 로직 수정 (2025-10-24)

### 🐛 버그 수정

#### JSON 매핑 로직 수정
- **문제점**: JSON 형식의 컬럼 오버라이드가 항상 첫 번째 값으로 변환되는 버그 수정
  - 이전: `selectivelyApplyGlobalColumnOverrides` 함수에서 `resolveJsonValue` 호출로 인해 JSON의 첫 번째 값을 반환
  - 결과: 원본 데이터 값과 무관하게 항상 첫 번째 값으로 변환됨
  
- **개선사항**:
  - `selectivelyApplyGlobalColumnOverrides`에서 `resolveJsonValue` 호출 제거
  - JSON 문자열을 그대로 유지하여 `applyGlobalColumnOverrides`에서 실제 데이터 값에 따라 매핑
  - 매핑 실패 시 첫 번째 값 대신 **원본 값 유지**
  - 공백이 포함된 값도 trim하여 정확한 매칭
  
- **변환 예시:**
  ```xml
  <override column="status">{"COMPLETED":"FINISHED", "PENDING":"WAITING", "PROCESSING":"GOING"}</override>
  
  <!-- 원본 데이터의 status 값에 따라 -->
  "COMPLETED"  → "FINISHED"  (매핑 성공)
  "PENDING"    → "WAITING"   (매핑 성공)
  "SHIPPED"    → "SHIPPED"   (매핑 없음, 원본 유지)
  "ACTIVE "    → "ING"       (공백 자동 trim)
  null         → null        (null은 변환 안함)
  ```
  
- **수정 파일**:
  - `src/mssql-data-migrator-modular.js`: `selectivelyApplyGlobalColumnOverrides` 함수에서 `resolveJsonValue` 호출 제거
  - `src/modules/variable-manager.js`: `applyGlobalColumnOverrides` 함수의 JSON 매핑 로직 개선

---

## 🚀 v0.8.6 - 컬럼 오버라이드 로그 개선 (2025-10-23)

### 🔧 개선사항

#### 컬럼 오버라이드 로그 정확성 향상
- **실제 오버라이드된 컬럼만 표시**: 전역 컬럼 오버라이드 적용 시 실제로 데이터에 존재하고 오버라이드된 컬럼명만 로그에 표시
  - 이전: 전역 설정의 모든 컬럼을 표시 (일부는 실제 적용되지 않음)
  - 개선: 실제 데이터에 존재하는 컬럼만 필터링하여 정확한 로그 출력
  - 2단계 필터링: `applyGlobalColumns` 속성으로 1차 필터링 → 실제 데이터 존재 여부로 2차 필터링
  
- **예시:**
  ```xml
  <!-- 전역 설정: 7개 컬럼 정의 -->
  <globalColumnOverrides>
    <override column="payment_method">...</override>
    <override column="company_code">...</override>
    <override column="email">...</override>
    <override column="Created_By">110</override>
    <override column="created_date">${DATE.UTC:yyyy-MM-dd HH:mm:ss}</override>
    <override column="order_date">${DATE.KST:yyyy-MM-dd HH:mm:ss}</override>
    <override column="status">...</override>
  </globalColumnOverrides>
  
  <!-- products 테이블에 created_by, status만 존재 -->
  <query applyGlobalColumns="created_by,status">
    <!-- 로그: "전역 컬럼 오버라이드 적용 중: Created_By, status" -->
    <!-- (2개만 실제 적용됨을 명확히 표시) -->
  </query>
  ```

#### selectivelyApplyGlobalColumnOverrides 함수 호출 수정
- 전체 globalColumnOverrides를 복사하던 방식에서 선택적 필터링 함수를 실제로 호출하도록 개선
- 불필요한 중복 로그 제거

---

## 🚀 v0.8.5 - 글로벌 타임존 시스템 (2025-10-21)

### ✨ 새로운 기능

#### 글로벌 타임존 시스템
- **전 세계 22개 타임존 지원**: 강화된 날짜/시간 변수 기능
  - 새로운 구문: 특정 타임존의 경우 `${DATE.TIMEZONE:format}`, 로컬 시간의 경우 `${DATE:format}`
  - 아시아-태평양: UTC, GMT, KST, JST, CST, SGT, PHT, ICT, IST, AEST
  - 유럽/중동: CET (독일, 프랑스, 이탈리아, 폴란드), EET, GST
  - 아메리카: EST, AST, CST_US (미국, 캐나다, 멕시코), MST, PST, AKST, HST, BRT, ART
  - 지원 포맷 토큰: `YYYY`, `YY`, `MM`, `M`, `DD`, `D`, `HH`, `H`, `mm`, `m`, `ss`, `s`, `SSS`
  - 대소문자 구분 없는 토큰: `yyyy` = `YYYY`, `dd` = `DD`

- **로컬 시간 지원**: 타임존을 생략하면 서버의 로컬 타임존 사용
  - `${DATE:YYYY-MM-DD}` - 서버의 로컬 타임존 사용
  - 권장사항: 글로벌 일관성을 위해 명시적으로 타임존 지정

#### 사용 예시

**1. 타임존이 포함된 파일명:**
```xml
<targetTable>backup_${DATE.UTC:yyyyMMdd_HHmmss}</targetTable>
<targetTable>logs_${DATE.KST:yyyy-MM-dd}</targetTable>
```

**2. WHERE 조건:**
```xml
<columnOverrides>
  <column name="created_at">${DATE.UTC:yyyy-MM-DD HH:mm:ss}</column>
  <column name="updated_at">${DATE.KST:yyyy-MM-DD HH:mm:ss}</column>
</columnOverrides>
```

**3. 로컬 시간:**
```xml
<column name="process_date">${DATE:yyyy-MM-dd}</column>
```

**4. 다중 타임존 보고서:**
```xml
<!-- 소스: 한국 시간 -->
<query database="sourceDB">
  SELECT * FROM users WHERE created_at > '${DATE.KST:yyyy-MM-DD}'
</query>

<!-- 타겟: 미국 동부 시간 -->
<targetTable>users_backup_${DATE.EST:yyyyMMdd}</targetTable>
```

### 🔧 기술적 변경사항

#### variable-manager.js
- **`formatDate()` 메서드 추가**: 여러 토큰을 지원하는 사용자 정의 날짜 포맷터
  - 대문자 및 소문자 토큰 모두 지원 (yyyy/YYYY, dd/DD)
  - 연도, 월, 일, 시간, 분, 초, 밀리초 처리
  
- **`replaceTimestampFunctions()` 메서드 강화**:
  - 22개 타임존에 대한 타임존 오프셋 맵 추가
  - 로컬 시간 패턴 처리: `${DATE:format}`
  - 타임존 특정 패턴 처리: `${DATE.TIMEZONE:format}`
  - 기존 타임스탬프 함수와의 하위 호환성 유지

### 📊 지원 타임존

| 타임존 | 설명 | UTC 오프셋 | 지역 |
|--------|------|------------|------|
| **UTC** | 협정 세계시 | UTC+0 | 글로벌 표준 |
| **GMT** | 그리니치 표준시 | UTC+0 | 영국 |
| **KST** | 한국 표준시 | UTC+9 | 대한민국 |
| **JST** | 일본 표준시 | UTC+9 | 일본 |
| **CST** | 중국 표준시 | UTC+8 | 중국 |
| **SGT** | 싱가포르 표준시 | UTC+8 | 싱가포르 |
| **PHT** | 필리핀 표준시 | UTC+8 | 필리핀 |
| **AEST** | 호주 동부 표준시 | UTC+10 | 호주 (동부) |
| **ICT** | 인도차이나 표준시 | UTC+7 | 태국, 베트남 |
| **IST** | 인도 표준시 | UTC+5:30 | 인도 |
| **GST** | 걸프 표준시 | UTC+4 | UAE, 오만 |
| **CET** | 중앙 유럽 표준시 | UTC+1 | 독일, 프랑스, 이탈리아, 폴란드 |
| **EET** | 동유럽 표준시 | UTC+2 | 동유럽 |
| **EST** | 미국 동부 표준시 | UTC-5 | 미국 동부 해안 |
| **AST** | 대서양 표준시 | UTC-4 | 캐나다 동부 |
| **CST_US** | 미국 중부 표준시 | UTC-6 | 미국, 캐나다, 멕시코 중부 |
| **MST** | 미국 산악 표준시 | UTC-7 | 미국 산악 지역 |
| **PST** | 미국 서부 표준시 | UTC-8 | 미국 서부 해안 |
| **AKST** | 알래스카 표준시 | UTC-9 | 알래스카 |
| **HST** | 하와이 표준시 | UTC-10 | 하와이 |
| **BRT** | 브라질 표준시 | UTC-3 | 브라질 |
| **ART** | 아르헨티나 표준시 | UTC-3 | 아르헨티나 |

### 🔄 마이그레이션 가이드

**기존 형식 (여전히 지원됨):**
```xml
${CURRENT_TIMESTAMP}
${NOW}
${CURRENT_DATE}
```

**새로운 형식 (권장):**
```xml
${DATE:yyyy-MM-DD HH:mm:ss}      <!-- 로컬 시간 -->
${DATE.UTC:yyyy-MM-DD HH:mm:ss}  <!-- UTC 시간 -->
${DATE.KST:yyyy-MM-DD HH:mm:ss}  <!-- 한국 시간 -->
${DATE.EST:yyyy-MM-DD HH:mm:ss}  <!-- 미국 동부 시간 -->
```

## 🚀 v0.8.4 - 언어 설정 통일 및 환경 변수 기반 구성 (2025-10-19)

### 🔧 개선사항
- **언어 설정 통일**: 모든 모듈에서 환경 변수(`LANGUAGE`)로 언어 설정 통일
  - `app.js`: 명령줄 인수 대신 환경 변수 사용
  - `src/mssql-data-migrator-modular.js`: 환경 변수 기반 언어 설정
  - `src/modules/config-manager.js`: 기본값 'kr' → 'en' 변경
  - `src/mssql-connection-manager.js`: 기본값 'kr' → 'en' 변경
  - `src/progress-manager.js`: 기본값 'kr' → 'en' 변경
  - `src/logger.js`: 기본값 'kr' → 'en' 변경

- **배치 파일 개선**: 환경 변수 설정 추가, `--lang` 파라미터 제거
  - `run.bat`: `set LANGUAGE=en` 추가
  - `실행하기.bat`: `set LANGUAGE=kr` 추가
  - `release.bat`: 릴리스 배치 파일 템플릿에 환경 변수 설정 추가
  - `package.json`: `start:kr` 스크립트를 배치 파일 사용 안내로 변경

### 📝 문서
- 모든 언어 설정이 환경 변수 `LANGUAGE`를 통해 제어됨
- 기본값은 영어 ('en')로 통일
- 개발자 및 사용자 모두에게 일관된 언어 설정 경험 제공

### 🔄 마이그레이션 가이드
- 기존에 `node app.js --lang=kr` 형태로 실행하던 경우:
  - Windows: `set LANGUAGE=kr && node app.js`
  - 또는 `실행하기.bat` 사용 (자동으로 환경 변수 설정됨)
- 개발 환경에서는 `.env` 파일에 `LANGUAGE=kr` 설정 가능

## 🚀 v0.8.3 - 대소문자 구분 없는 컬럼 매칭 및 디버깅 강화 (2025-10-17)

### ✨ 새로운 기능

#### 대소문자 구분 없는 컬럼 매칭
- **identityColumns**: 대소문자 무관하게 타겟 테이블 컬럼 자동 매칭
  - 예: `identityColumns="username"`이 타겟 테이블의 `username`, `Username` 모두 매칭
  - 대소문자 불일치로 인한 삭제 실패 방지
  
- **globalColumnOverrides**: 대소문자 구분 없는 컬럼명 처리
  - 어떤 대소문자로 정의해도 동일하게 인식 (예: `Created_By`, `CREATED_BY`, `created_by`)
  - 중복 감지 시 대소문자 차이 무시
  - 실제 테이블 컬럼명으로 오버라이드 값 적용
  
- **applyGlobalColumns**: 대소문자 구분 없는 키워드 및 컬럼명 매칭
  - 키워드: `all`, `All`, `ALL`, `none`, `None`, `NONE` 모두 작동
  - 컬럼명: `UpdatedBy`, `updatedby`, `UPDATEDBY` 모두 매칭
  - 여러 컬럼: `created_by, STATUS` 등 대소문자 조합 무관

#### 로그 비밀번호 마스킹
- **자동 비밀번호 마스킹**: 로그의 모든 비밀번호 필드를 자동으로 `********`로 마스킹
- **마스킹 대상**: `password`, `pwd`, `passwd` 및 "password"가 포함된 모든 필드
- **적용 범위**: 콘솔 출력 및 로그 파일
- **중첩 객체**: 중첩된 설정의 비밀번호도 재귀적으로 마스킹

### 🔧 개선 사항

#### SQL Server 2100 파라미터 제한 처리
- **자동 청크 처리**: `deleteBeforeInsert`가 대량 PK를 청크로 분할
- **청크 크기 계산**:
  - 단일 키: 청크당 2000개 값
  - 복합 키 (2개 컬럼): 청크당 1000개 값
  - 복합 키 (3개 컬럼): 청크당 666개 값
- **진행 상황 로깅**: 대량 데이터 처리 시 청크 진행 상황 표시
- **파라미터 제한 오류 해결**: 행 수에 관계없이 처리 가능

#### 삭제 작업 디버깅 강화
- **데이터베이스 식별**: 어느 DB(소스/타겟)에서 작업하는지 명확히 표시
- **상세 진단**: 삭제 작업 실패 시 자동 진단
  - 타겟 테이블 행 수 표시
  - 샘플 PK 값으로 테스트
  - 타겟 테이블의 실제 PK 값 표시
  - 가능한 원인 제시
- **명확한 메시지**: 
  - "타겟 테이블이 비어있습니다. 삭제할 데이터가 없으므로 INSERT만 진행합니다"
  - "타겟 테이블에 N행이 있지만, 소스 PK 값과 일치하는 데이터가 없습니다"

### 🐛 버그 수정
- **deleteBeforeInsert 파라미터 오버플로**: SQL Server 2100 파라미터 제한 오류 수정
- **대소문자 구분 컬럼 매칭**: XML 컬럼명이 DB 실제 대소문자와 다를 때 실패 수정
- **전역 컬럼 오버라이드 미적용**: 컬럼명 대소문자가 다를 때 오버라이드 실패 수정
- **identityColumns 불일치**: 대소문자 차이로 삭제 작업 건너뛰기 수정

### 📝 기술적 변경사항
- **mssql-connection-manager.js**:
  - 대소문자 구분 없는 컬럼 매칭을 위한 `normalizeColumnName()` 추가
  - `deleteFromTargetByPK()`에 청크 처리 구현
  - DB 정보 및 진단 정보가 포함된 로깅 강화
  
- **config-manager.js**:
  - `parseGlobalColumnOverrides()`에 대소문자 구분 없는 중복 감지 추가
  - 첫 번째 정의된 컬럼명 형식 유지
  
- **mssql-data-migrator-modular.js**:
  - 대소문자 구분 없는 매칭으로 `selectivelyApplyGlobalColumnOverrides()` 업데이트
  - 효율적인 대소문자 구분 없는 조회를 위한 컬럼 맵 생성
  
- **modules/variable-manager.js**:
  - 대소문자 구분 없이 실제 컬럼명을 찾도록 `applyGlobalColumnOverrides()` 업데이트
  - 오버라이드 값이 올바른 컬럼에 적용되도록 보장
  
- **logger.js**:
  - `maskSensitiveData()` 메서드 추가
  - 모든 로그 출력에서 자동 비밀번호 마스킹

### 🎯 사용 예시

#### 대소문자 구분 없는 컬럼 매칭
```xml
<!-- globalColumnOverrides 정의 -->
<globalColumnOverrides>
  <override column="Created_By">SYSTEM</override>
  <override column="UPDATED_BY">ADMIN</override>
</globalColumnOverrides>

<!-- 대소문자에 관계없이 모두 작동 -->
<query>
  <sourceQuery applyGlobalColumns="created_by, updated_by">
    SELECT * FROM users
  </sourceQuery>
</query>

<query>
  <sourceQuery applyGlobalColumns="CREATED_BY, UPDATED_BY">
    SELECT * FROM products
  </sourceQuery>
</query>
```

#### identityColumns 대소문자 처리
```xml
<!-- 타겟 테이블이 "Username" (대문자 U)이어도 작동 -->
<sourceQuery 
  targetTable="users" 
  identityColumns="username"
  deleteBeforeInsert="true">
  SELECT * FROM users
</sourceQuery>
```

## 🚀 v0.8.2 - 구조 개선 및 검증 강화 (2025-10-14)

### 🔧 기술적 개선

#### dbinfo.json 구조 개선
- **dbs 래퍼 제거**: DB 설정을 직접 루트에 배치
  - 변경 전: `{"dbs": {"sampleDB": {...}}}`
  - 변경 후: `{"sampleDB": {...}}`
  - 더 간결한 구조로 가독성 향상
  - 모든 관련 코드 업데이트:
    - `mssql-connection-manager.js`: config.dbs → config 직접 사용
    - `migrate-cli.js`: dbInfo.dbs → dbInfo 직접 사용
    - `config-manager.js`: dbInfo.dbs → dbInfo 직접 사용

#### pkg 환경 경로 처리 개선
- **APP_ROOT 상수 사용**: pkg 환경과 개발 환경 모두에서 올바른 파일 경로 사용
  - `mssql-connection-manager.js`: pkg 환경 경로 처리 추가
  - `migrate-cli.js`: validate 명령 시 --xml 옵션 파싱 개선
  - 디버그 로그 추가: queryDef 파싱 과정 추적

### 🐛 버그 수정
- **validate 명령 queryDef 인식 오류**: queryDef의 id 속성 인식 개선
- **validate-config.bat 무한 루프**: 파일 선택 메뉴 추가로 개선
- **pkg 환경 파일 경로 오류**: APP_ROOT 사용으로 해결

## 🚀 v0.8.1 - XML 전용 설정 지원 (2025-10-11)

### 🔄 주요 변경 사항

#### JSON 쿼리문정의 파일 지원 제거
- **XML 전용**: 쿼리문정의 파일은 이제 XML 형식만 지원
- **간소화된 아키텍처**: 더 깨끗한 코드베이스를 위해 JSON 파싱 로직 제거
- **명확한 오류 메시지**: JSON 파일 사용 시도 시 명확한 오류 제공
- **일관된 문서화**: 모든 문서가 XML 전용 지원을 반영하도록 업데이트

### 📝 변경 내용

#### 코드 업데이트
- **migrate-cli.js**: XML 형식만 지정하도록 도움말 텍스트 업데이트
- **config-manager.js**: XML이 아닌 파일을 거부하는 검증 추가
- **삭제된 파일**: `queries/migration-queries.json` 샘플 파일 삭제

#### 문서 업데이트
- **README.md**: JSON 형식 섹션 및 예제 제거
- **README_KR.md**: JSON 형식 섹션 및 예제 제거
- **USER_MANUAL.md**: 설정 형식 설명 업데이트
- **USER_MANUAL_KR.md**: 설정 형식 설명 업데이트
- **CHANGELOG.md**: JSON 참조 제거
- **CHANGELOG_KR.md**: JSON 참조 제거

### 💡 마이그레이션 가이드

JSON 쿼리문정의 파일을 사용하고 있었다면:

1. **XML로 변환**: 문서에 표시된 XML 형식 구조 사용
2. **파일 확장자 변경**: `.json`을 `.xml`로 변경
3. **구문 조정**: 적절한 태그와 CDATA 섹션이 있는 XML 구조 따르기

**변환 예시:**
```json
// 이전 JSON 형식 (더 이상 지원되지 않음)
{
  "queries": [{
    "id": "migrate_users",
    "sourceQuery": "SELECT * FROM users"
  }]
}
```

```xml
<!-- 새로운 XML 형식 -->
<migration>
  <queries>
    <query id="migrate_users">
      <sourceQuery>
        <![CDATA[SELECT * FROM users]]>
      </sourceQuery>
    </query>
  </queries>
</migration>
```

### 🎯 변경 이유

- **단일 형식**: 하나의 설정 형식 유지로 복잡성 감소
- **더 나은 구조**: XML은 복잡한 설정에 더 나은 구조 제공
- **CDATA 지원**: XML CDATA 섹션은 SQL 쿼리를 더 자연스럽게 처리
- **업계 표준**: XML은 데이터베이스 마이그레이션 도구에서 더 일반적

---

## 🚀 v0.8.0 - 대화형 인터페이스 및 독립 실행 파일 지원 (2025-10-11)

### ✨ 새로운 기능

#### 대화형 커맨드라인 인터페이스 (app.js)
- **사용자 친화적 메뉴**: 쉬운 조작을 위한 대화형 메뉴 시스템
- **번호로 파일 선택**: 전체 경로 입력 없이 번호로 쿼리문정의 파일 선택
- **다국어 지원**: 영어 및 한글 인터페이스 지원 (--lang 옵션)
- **통합 작업**: 단일 인터페이스에서 모든 일반 작업 접근 가능
  - 쿼리문정의 파일 검증
  - 데이터베이스 연결 테스트
  - 데이터 이관 실행
  - 이관 진행 상황 모니터링

#### 이관 진행 상황 모니터링
- **최근 이력 보기**: 기본적으로 최근 3개 이관 작업 표시
- **전체 이력 접근**: 'A' 명령으로 모든 이관 이력 보기 토글
- **상세 진행 정보**: 모든 이관 작업의 포괄적인 상세 정보 조회
  - 이관 상태 및 타임스탬프
  - 쿼리별 진행 상황 추적
  - 행 수 및 처리 속도
  - 오류 정보 및 스택 트레이스
- **대화형 탐색**: 목록과 상세 보기 간 쉬운 탐색

#### 독립 실행 파일 지원
- **PKG 통합**: `npm run build`로 독립 실행 Windows 실행 파일 빌드
- **Node.js 불필요**: Node.js 설치 없이 이관 실행
- **완전한 패키지**: 모든 의존성 및 리소스 포함
- **최적화된 빌드**: 더 작은 파일 크기를 위한 GZip 압축
- **경로 처리**: 패키지 환경에서 자동 경로 처리

#### 자동화된 배포 프로세스
- **배포 스크립트**: 자동 패키징을 위한 포괄적인 `release.bat`
- **패키지 구조**: 체계적인 디렉토리로 구성된 전문적인 배포 패키지
- **실행 스크립트**: 영어 및 한글 버전 전용 배치 파일
- **문서화**: 버전 정보, 릴리스 노트, 매뉴얼 포함
- **ZIP 아카이브**: 배포를 위한 자동 ZIP 파일 생성

### 🔄 개선 사항

#### 모듈화 아키텍처 리팩토링
- **관심사 분리**: 모놀리식 코드를 집중된 모듈로 분할
  - `config-manager.js`: 설정 로드 및 파싱
  - `variable-manager.js`: 동적 변수 관리
  - `query-processor.js`: SQL 쿼리 처리
  - `script-processor.js`: 전/후처리 스크립트 실행
- **향상된 유지보수성**: 더 이해하기 쉽고 수정하기 쉬운 코드
- **더 나은 테스트**: 개별 모듈을 독립적으로 테스트 가능
- **API 호환성**: 기존 설정과의 하위 호환성 유지

#### 강화된 설정 검증
- **속성명 검증**: 모든 XML 속성명 검증
- **상세한 오류 메시지**: 검증 실패 시 허용되는 속성 표시
- **포괄적인 검사**: 모든 설정 섹션 검증
  - 설정 속성
  - 쿼리 속성
  - 동적 변수 속성
  - 전/후처리 속성
  - 전역 처리 그룹 속성

#### PKG 환경 지원
- **경로 처리**: 패키지된 실행 파일에서 올바른 `__dirname` 처리
- **디렉토리 생성**: 로그 및 출력 디렉토리를 위한 대체 메커니즘
- **모듈 로딩**: CLI 실행 대신 직접 모듈 require()
- **리소스 포함**: 쿼리, 설정, 리소스의 적절한 번들링

### 🛠️ 사용 예시

#### 대화형 인터페이스
```bash
# 영문 버전
npm start
# 또는
run.bat

# 한글 버전
npm run start:kr
# 또는
실행하기.bat

# 독립 실행 파일
sql2db.exe --lang=en
sql2db.exe --lang=kr
```

#### 진행 상황 모니터링
```
이관 작업 이력 (최근 3개):

1. migration-2025-10-11-01-45-35
   상태: COMPLETED
   시작: 2025-10-11 오전 1:45:35
   진행: 25/25 queries
   완료: 2025-10-11 오전 1:48:20 (165s)

Showing 3 of 15 migration(s)

상세 정보를 볼 번호를 입력하세요 ('A': 전체보기, '0': 뒤로가기):
```

#### 실행 파일 빌드
```bash
# 독립 실행 파일 빌드
npm run build

# 배포 패키지 생성
npm run release

# 출력: release/sql2db-v0.8.0-bin.zip
```

### 📦 배포 패키지 내용
- `sql2db.exe`: 독립 실행 파일
- `run.bat`: 영문 실행 스크립트
- `실행하기.bat`: 한글 실행 스크립트
- `config/`: 데이터베이스 설정 파일
- `queries/`: 쿼리문정의 파일
- `resources/`: SQL 리소스 파일
- `user_manual/`: 완전한 문서

### 🔧 기술적 개선사항
- **향상된 오류 처리**: 패키지 환경에서 포괄적인 오류 메시지
- **메모리 관리**: CLI 인터페이스를 위한 최적화된 리소스 사용
- **파일 시스템 작업**: 대체 옵션이 있는 안전한 디렉토리 생성
- **콘솔 출력**: 개선된 포맷팅 및 색상 코딩 메시지

### 📊 성능
- **빠른 시작**: 대화형 인터페이스의 빠른 초기화
- **효율적인 진행 추적**: 모니터링을 위한 최소 오버헤드
- **최적화된 빌드**: 모든 의존성 포함 ~50MB 실행 파일

### 🎯 마이그레이션 경로
- **설정 불필요**: 기존 쿼리 파일이 변경 없이 작동
- **API 호환**: 모든 CLI 명령어 여전히 기능
- **점진적 개선**: CLI와 대화형 인터페이스 중 선택

---

## 🔧 v0.7.1 - 다중 데이터베이스 동적변수 지원 확장 (2025-09-01)

### ✨ 새로운 기능

#### dbinfo.json 모든 데이터베이스에서 동적변수 추출 지원
- **전체 DB 지원**: dbinfo.json에 정의된 모든 데이터베이스에서 동적변수 추출 가능
- **자동 연결 관리**: 각 DB별로 별도의 연결 풀 생성 및 관리
- **에러 처리 강화**: 잘못된 DB 지정 시 사용 가능한 DB 목록 표시

#### 사용 예시
```xml
<!-- 여러 DB에서 동적변수 추출 -->
<dynamicVariables>
  <!-- 소스 DB에서 사용자 목록 -->
  <dynamicVar variableName="sourceUsers" database="sourceDB">
    SELECT user_id FROM users WHERE status = 'ACTIVE'
  </dynamicVar>
  
  <!-- 타겟 DB에서 부서 정보 -->
  <dynamicVar variableName="targetDepts" database="targetDB">
    SELECT dept_id FROM departments WHERE is_active = 1
  </dynamicVar>
  
  <!-- 샘플 DB에서 회사 정보 -->
  <dynamicVar variableName="companyInfo" database="sampleDB">
    SELECT company_code, company_name FROM companies
  </dynamicVar>
</dynamicVariables>
```

### 🔄 개선 사항

#### Connection Manager 확장
- **loadDBConfigs()**: dbinfo.json에서 DB 설정 자동 로드
- **connectToDB(dbKey)**: 특정 DB에 연결
- **queryDB(dbKey, query)**: 특정 DB에서 쿼리 실행
- **getAvailableDBKeys()**: 사용 가능한 모든 DB 키 목록 반환
- **disconnectDB(dbKey)**: 특정 DB 연결 해제
- **disconnectAllDBs()**: 모든 DB 연결 해제

#### 동적변수 추출 로직 개선
- **데이터베이스 유효성 검사**: 지정된 DB가 dbinfo.json에 존재하는지 확인
- **자동 연결**: 동적변수 추출 시 필요한 DB에 자동 연결
- **에러 메시지 개선**: 사용 가능한 DB 목록과 함께 명확한 에러 정보 제공

### 🛠️ 기술적 개선사항
- **연결 풀 관리**: 각 DB별로 독립적인 연결 풀 생성 및 관리
- **메모리 최적화**: 불필요한 연결은 자동으로 해제
- **에러 복구**: DB 연결 실패 시 적절한 에러 처리 및 복구

### 📊 활용 사례
- **복잡한 마이그레이션**: 여러 DB에서 조건 데이터 추출 후 통합 마이그레이션
- **교차 DB 참조**: 소스에서 마스터 데이터, 타겟에서 매핑 정보 추출
- **테스트 환경**: 샘플 DB에서 테스트 데이터 추출하여 마이그레이션 검증

---

## 🔧 v0.7 - 동적 변수 및 SQL 처리 개선 (2025-08-29)

### ✨ 새로운 기능

#### 동적 변수 데이터베이스 지정 기능
- **데이터베이스 선택**: 동적 변수에서 `database` 속성으로 소스/타겟 DB 선택 가능
- **기본값 제공**: 속성 미지정 시 `sourceDB`를 기본값으로 사용
- **교차 DB 활용**: 소스에서 조건 추출 후 타겟에서 관련 데이터 조회 가능

#### 사용 예시
```xml
<!-- 소스 DB에서 사용자 ID 추출 -->
<dynamicVar id="extract_source_users"
            variableName="sourceUserIds"
            extractType="single_column"
            columnName="user_id"
            database="sourceDB">
  <![CDATA[SELECT user_id FROM users WHERE status = 'ACTIVE']]>
</dynamicVar>

<!-- 타겟 DB에서 매핑 정보 추출 -->
<dynamicVar id="extract_target_mapping"
            variableName="targetMapping"
            extractType="key_value_pairs"
            database="targetDB">
  <![CDATA[SELECT old_id, new_id FROM id_mapping]]>
</dynamicVar>
```

### 🔄 개선 사항

#### SELECT * 패턴 개선
- **정확한 별칭 감지**: SQL 키워드(WHERE, GROUP, HAVING 등)를 별칭으로 오인하지 않음
- **안전한 패턴 매칭**: 더 정확한 정규식 패턴으로 테이블 별칭 추출
- **오류 방지**: 잘못된 컬럼명 생성으로 인한 SQL 오류 방지

**개선 전후 비교:**
```sql
-- 개선 전 (문제 상황)
SELECT * FROM products WHERE status = 'ACTIVE'
-- 잘못된 변환: SELECT WHERE.product_name, WHERE.product_code FROM products WHERE status = 'ACTIVE'

-- 개선 후 (정상 동작)
SELECT * FROM products WHERE status = 'ACTIVE'
-- 정상 변환: SELECT product_name, product_code, category_id FROM products WHERE status = 'ACTIVE'
```

#### DRY RUN 모드 강화
- **실제 동적 변수 추출**: DRY RUN에서도 동적 변수를 실제로 추출하여 저장
- **정확한 쿼리 시뮬레이션**: 추출된 동적 변수 값을 사용한 정확한 쿼리 검증
- **오류 사전 감지**: 동적 변수 관련 오류를 DRY RUN 단계에서 미리 발견

#### 오류 처리 및 안정성 개선
- **안전한 변수 치환**: 동적 변수가 아직 추출되지 않은 상태에서도 안전하게 처리
- **Graceful Fallback**: 기능 실패 시 원본 데이터로 안전하게 복구
- **상세한 오류 메시지**: 문제 발생 시 더 명확한 오류 정보 제공

### 🛠️ 디버깅 지원
```bash
# 동적 변수 처리 과정 상세 로그
DEBUG_VARIABLES=true node src/migrate-cli.js migrate queries.xml

# SELECT * 처리 과정 확인
DEBUG_SCRIPTS=true node src/migrate-cli.js migrate queries.xml
```

### 📊 활용 사례
- **소스 DB 추출**: 마이그레이션 대상 데이터 식별
- **타겟 DB 추출**: 기존 매핑 정보나 참조 데이터 조회
- **교차 DB 활용**: 소스에서 조건 추출 후 타겟에서 관련 데이터 조회

---

## 🔧 v0.6 - 처리 단계별 컬럼 오버라이드 제어 (2024-08-14)

### ✨ 새로운 기능

#### 처리 단계별 applyGlobalColumns 제어
- **세분화된 제어**: preProcess, sourceQuery, postProcess 각 단계별로 개별 applyGlobalColumns 설정 가능
- **유연한 컬럼 적용**: 단계별 목적에 맞게 필요한 전역 컬럼만 선택적 적용
- **성능 최적화**: 불필요한 컬럼 처리 생략으로 성능 향상

#### 단계별 설정 방식
```xml
<query id="migrate_users" targetTable="users" ...>
  <preProcess description="백업" applyGlobalColumns="created_by,updated_by">
    <![CDATA[INSERT INTO user_backup SELECT * FROM users;]]>
  </preProcess>
  
  <sourceQuery applyGlobalColumns="all">
    <![CDATA[SELECT user_id, username, email FROM users_source;]]>
  </sourceQuery>
  
  <postProcess description="로그" applyGlobalColumns="migration_date">
    <![CDATA[INSERT INTO migration_log VALUES ('users', GETDATE());]]>
  </postProcess>
</query>
```

### 🔄 변경 사항
- **기존**: query 레벨에서 단일 applyGlobalColumns 설정
- **신규**: 각 처리 단계별로 독립적인 applyGlobalColumns 설정

### 📝 사용 예시

#### 단계별 컬럼 적용
- **preProcess**: 백업 테이블에는 생성자 정보만 (`created_by`)
- **sourceQuery**: 실제 데이터 이관에는 모든 컬럼 (`all`)
- **postProcess**: 로그 테이블에는 타임스탬프만 (`migration_date`)

이를 통해 각 단계의 목적에 맞는 최적화된 컬럼 오버라이드 적용이 가능합니다.

## 🎯 v0.5 - 전역 전/후처리 그룹 관리 (2024-08-14)

### ✨ 새로운 기능

#### 전역 전/후처리 그룹 시스템
- **간단한 그룹화**: globalProcesses 내에서 전/후처리를 기능별 그룹으로 관리
- **순차 실행**: 정의된 순서대로 그룹별 실행
- **개별 제어**: 각 그룹별 활성화/비활성화 설정
- **완전한 동적 변수 지원**: 모든 그룹에서 동적 변수 사용 가능

#### 기본 제공 그룹 예시
1. **performance_setup**: 성능 최적화 설정 (인덱스/제약조건 비활성화)
2. **logging**: 마이그레이션 로그 초기화
3. **validation**: 데이터 검증 및 품질 체크
4. **performance_restore**: 성능 최적화 복원 (인덱스/제약조건 재활성화)
5. **verification**: 이관 후 데이터 검증
6. **completion**: 완료 로그 및 통계

### 🔄 실행 순서
1. **전역 전처리 그룹들** (정의된 순서대로)
2. 동적 변수 추출
3. 개별 쿼리 마이그레이션
4. **전역 후처리 그룹들** (정의된 순서대로)

### 🛡️ 오류 처리
- **전처리 그룹 오류**: 마이그레이션 전체 중단
- **후처리 그룹 오류**: 경고 로그 후 다음 그룹 계속 진행

### 📝 사용 예시

#### XML 그룹 설정
```xml
<globalProcesses>
  <preProcessGroups>
    <group id="performance_setup" description="성능 최적화 설정" enabled="true">
      <![CDATA[
        -- 인덱스 비활성화
        ALTER INDEX ALL ON users DISABLE;
        ALTER INDEX ALL ON products DISABLE;
        
        -- 제약조건 비활성화
        ALTER TABLE users NOCHECK CONSTRAINT ALL;
        ALTER TABLE products NOCHECK CONSTRAINT ALL;
      ]]>
    </group>
    
    <group id="validation" description="데이터 검증" enabled="true">
      <![CDATA[
        -- 중복 데이터 체크 (동적 변수 사용)
        IF EXISTS (SELECT user_id, COUNT(*) FROM users_source GROUP BY user_id HAVING COUNT(*) > 1)
        BEGIN
          RAISERROR('중복된 사용자 ID가 발견되었습니다.', 16, 1);
        END
        
        -- 활성 사용자 검증
        INSERT INTO validation_log 
        SELECT 'ACTIVE_USER_CHECK', COUNT(*), GETDATE()
        FROM users_source WHERE user_id IN (${activeUserIds});
      ]]>
    </group>
  </preProcessGroups>
  
  <postProcessGroups>
    <group id="performance_restore" description="성능 최적화 복원" enabled="true">
      <![CDATA[
        -- 제약조건 재활성화
        ALTER TABLE users WITH CHECK CHECK CONSTRAINT ALL;
        ALTER TABLE products WITH CHECK CHECK CONSTRAINT ALL;
        
        -- 인덱스 재활성화
        ALTER INDEX ALL ON users REBUILD;
        ALTER INDEX ALL ON products REBUILD;
      ]]>
    </group>
    
    <group id="completion" description="완료 로깅" enabled="true">
      <![CDATA[
        -- 최종 통계
        INSERT INTO migration_completion_log 
        SELECT 'MIGRATION_COMPLETE', GETDATE(), 
               (SELECT COUNT(*) FROM users),
               (SELECT COUNT(*) FROM products);
      ]]>
    </group>
  </postProcessGroups>
</globalProcesses>
```

## 🔄 v0.4 - 동적 변수 시스템 개선 (2024-08-13)

### ✨ 새로운 기능

#### 향상된 동적 변수 시스템
- **기본 타입 단순화**: `extractType`이 지정되지 않으면 자동으로 `column_identified` 동작으로 기본 설정
- **개선된 변수 타입**: 사용성을 위해 3개 타입에서 2개 타입으로 간소화
- **향상된 오류 처리**: 해결되지 않은 변수와 엣지 케이스에 대한 더 나은 처리

### 🔄 변경 사항

#### 기본 타입 동작
- **이전**: 명시적인 `extractType` 지정 필요
- **신규**: `extractType`이 생략되면 `column_identified`로 기본 설정

#### 변수 타입 단순화
| 타입 | 설명 | 접근 패턴 | 기본값 |
|------|-------------|----------------|---------|
| `column_identified` | 모든 컬럼을 컬럼명으로 키를 가진 배열로 추출 | `${varName.columnName}` | ✅ 예 |
| `key_value_pairs` | 처음 두 컬럼을 키-값 쌍으로 추출 | `${varName.key}` | 아니오 |

### 📝 사용 예시

#### 간소화된 설정
```xml
<dynamicVariables>
  <!-- column_identified 사용 (기본값) - extractType 불필요 -->
  <dynamicVar id="customer_data" description="고객 정보">
    <query>SELECT CustomerID, CustomerName, Region FROM Customers</query>
  </dynamicVar>
  
  <!-- key_value_pairs 사용 - 명시적 지정 필요 -->
  <dynamicVar id="status_mapping" description="상태 매핑">
    <query>SELECT StatusCode, StatusName FROM StatusCodes</query>
    <extractType>key_value_pairs</extractType>
  </dynamicVar>
</dynamicVariables>
```

### 🔧 개선사항
- **사용성 향상**: `column_identified`를 기본값으로 설정하여 설정 복잡성 감소
- **일관성**: 도구 간 일관성을 위해 sql2excel 동작과 정렬
- **문서화**: 새로운 기본 동작을 반영하여 모든 문서 업데이트

## 📈 v0.3.0 - 진행 상황 관리 시스템 (2024-08-12)

### ✨ 새로운 기능

#### 실시간 진행 상황 추적
- **라이브 모니터링**: 실시간 마이그레이션 진행 상황 모니터링
- **성능 메트릭**: 처리 속도 및 예상 완료 시간
- **상세 분석**: 단계, 쿼리, 배치 레벨 상세 정보
- **중단 복구**: 완료된 지점에서 중단된 마이그레이션 재개
- **영구 저장**: 이력 관리를 위한 진행 상황 파일
- **CLI 도구**: 다양한 쿼리 및 관리 명령어

### 🛠️ 진행 상황 관리 명령어
```bash
# 모든 마이그레이션 목록
node src/progress-cli.js list

# 특정 마이그레이션 상세 정보
node src/progress-cli.js show migration-2024-12-01-15-30-00

# 실시간 모니터링
node src/progress-cli.js monitor migration-2024-12-01-15-30-00

# 재개 정보
node src/progress-cli.js resume migration-2024-12-01-15-30-00

# 중단된 마이그레이션 재시작
node src/migrate-cli.js resume migration-2024-12-01-15-30-00 --query ./queries/migration-queries.xml

# 전체 요약
node src/progress-cli.js summary

# 오래된 파일 정리
node src/progress-cli.js cleanup 7
```

### 📊 진행 상황 파일 구조
```json
{
  "migrationId": "migration-2024-12-01-15-30-00",
  "startTime": "2024-12-01T15:30:00.000Z",
  "status": "IN_PROGRESS",
  "totalQueries": 5,
  "completedQueries": 2,
  "currentQuery": "migrate_users",
  "currentBatch": 1500,
  "totalBatches": 5000,
  "progress": {
    "percentage": 40.0,
    "estimatedCompletion": "2024-12-01T16:45:00.000Z"
  }
}
```

## ⭐ v0.2.3 - SELECT * 자동 처리 (2024-08-11)

### ✨ 새로운 기능

#### SELECT * 자동 처리
- **자동 감지**: `SELECT * FROM table_name` 패턴 자동 감지
- **IDENTITY 컬럼 제외**: 타겟 테이블의 IDENTITY 컬럼을 자동으로 식별하고 제외
- **자동 컬럼 목록 생성**: `targetColumns` 자동 설정
- **소스 쿼리 변환**: `SELECT *`를 명시적 컬럼 목록으로 변환

### 📝 사용 예시
```xml
<query id="migrate_users" targetTable="users" enabled="true">
  <sourceQuery>
    <![CDATA[SELECT * FROM users WHERE status = 'ACTIVE']]>
  </sourceQuery>
  <!-- targetColumns 자동 설정 (IDENTITY 컬럼 제외) -->
</query>
```

### 🔄 처리 단계
1. `SELECT *` 패턴 감지
2. 타겟 테이블의 모든 컬럼 조회
3. IDENTITY 컬럼 식별 및 제외
4. `targetColumns` 자동 설정
5. 소스 쿼리를 명시적 컬럼 목록으로 변환

### 📋 로그 예시
```
SELECT * 감지됨. 테이블 users의 컬럼 정보를 자동으로 가져오는 중.
IDENTITY 컬럼 자동 제외: id
자동 설정된 컬럼 목록 (15개 컬럼, IDENTITY 제외): name, email, status, created_date, ...
수정된 소스 쿼리: SELECT name, email, status, created_date, ... FROM users WHERE status = 'ACTIVE'
```

## 🔧 v0.2.1 - 컬럼 오버라이드 개선 (2024-08-10)

### ✨ 새로운 기능

#### 향상된 컬럼 오버라이드 시스템
- **전역 컬럼 오버라이드**: 모든 쿼리에 오버라이드 적용
- **전/후처리 오버라이드**: 전/후처리 스크립트에서 오버라이드 적용
- **고급 SQL 파싱**: 주석이 포함된 복잡한 SQL 문 지원
- **개선된 오류 처리**: 더 나은 오류 메시지 및 복구

### 📝 사용 예시

#### 전역 컬럼 오버라이드
```xml
<!-- 간단한 값 -->
<globalColumnOverrides>
  <override column="created_by">SYSTEM</override>
  <override column="created_date">${CURRENT_TIMESTAMP}</override>
  <override column="migration_source">LEGACY_SYSTEM</override>
</globalColumnOverrides>

<!-- JSON 값 -->
<globalColumnOverrides>
  <override column="data_version">{"users": "2.1", "orders": "2.2", "products": "2.3", "default": "2.0"}</override>
  <override column="migration_date">{"sourceDB": "${CURRENT_DATE}", "targetDB": "2024-12-31", "default": "${CURRENT_DATE}"}</override>
</globalColumnOverrides>
```

#### 전/후처리 오버라이드
```xml
<preProcess description="오버라이드와 함께 백업" applyGlobalColumns="all">
  <![CDATA[
    INSERT INTO backup_table (id, name, created_by, created_date)
    SELECT id, name, 'BACKUP_SYSTEM', GETDATE()
    FROM target_table;
  ]]>
</preProcess>
```

## 🔄 v0.2.0 - 동적 변수 시스템 (2024-08-09)

### ✨ 새로운 기능

#### 동적 변수 시스템
- **런타임 데이터 추출**: 런타임에 데이터베이스에서 데이터 추출
- **변수 타입**: `column_identified` 및 `key_value_pairs` 타입 지원
- **쿼리 통합**: 마이그레이션 쿼리에서 동적 변수 사용
- **오류 처리**: 변수 해결 실패에 대한 우아한 처리
- **데이터베이스 선택**: 소스 또는 타겟 데이터베이스 지정을 위한 `database` 속성 지원

### 📝 사용 예시

#### 동적 변수 정의
```xml
<dynamicVariables>
  <dynamicVar id="active_customers" description="활성 고객 목록">
    <query>SELECT CustomerID FROM Customers WHERE IsActive = 1</query>
    <extractType>column_identified</extractType>
    <database>sourceDB</database>
  </dynamicVar>
  
  <dynamicVar id="status_mapping" description="상태 매핑">
    <query>SELECT StatusCode, StatusName FROM StatusCodes</query>
    <extractType>key_value_pairs</extractType>
    <database>sourceDB</database>
  </dynamicVar>
  
  <dynamicVar id="max_order_id" description="최대 주문 ID">
    <query>SELECT MAX(OrderID) as max_id FROM Orders</query>
    <extractType>single_value</extractType>
    <database>targetDB</database>
  </dynamicVar>
</dynamicVariables>
```

#### 쿼리에서 사용
```sql
SELECT * FROM Orders 
WHERE CustomerID IN (${active_customers.CustomerID})
  AND Status IN (${status_mapping.StatusCode})
```

## 📋 v0.1.9 - 로깅 및 모니터링 (2024-08-08)

### ✨ 새로운 기능

#### 향상된 로깅 시스템
- **5단계 로깅**: DEBUG, INFO, WARN, ERROR, FATAL
- **구조화된 로그**: 더 나은 파싱을 위한 JSON 형식
- **로그 로테이션**: 자동 로그 파일 로테이션
- **성능 메트릭**: 상세한 성능 추적

#### 실시간 모니터링
- **라이브 진행 상황**: 실시간 마이그레이션 진행 상황 표시
- **성능 차트**: 시각적 성능 메트릭
- **인터랙티브 인터페이스**: 키보드 기반 모니터링 인터페이스

### 📊 로그 레벨
- **DEBUG**: 상세한 디버깅 정보
- **INFO**: 일반적인 마이그레이션 진행 상황 정보
- **WARN**: 경고 메시지 (비중요한 문제)
- **ERROR**: 오류 메시지 (마이그레이션 계속 가능)
- **FATAL**: 치명적인 오류 (마이그레이션 중단)

## 🛠️ v0.1.8 - CLI 및 배치 개선 (2024-08-07)

### ✨ 새로운 기능

#### 향상된 CLI 인터페이스
- **인터랙티브 메뉴**: 사용자 친화적인 인터랙티브 메뉴 시스템
- **명령어 검증**: 개선된 명령어 검증 및 오류 메시지
- **도움말 시스템**: 포괄적인 도움말 문서
- **배치 파일 지원**: 쉬운 실행을 위한 Windows 배치 파일

#### 새로운 명령어
```bash
# 인터랙티브 메뉴
migrate.bat

# 설정 검증
node src/migrate-cli.js validate --query ./queries/migration-queries.xml

# 데이터베이스 연결 테스트
node src/migrate-cli.js list-dbs

# 드라이 런 시뮬레이션
node src/migrate-cli.js migrate --query ./queries/migration-queries.xml --dry-run
```

## 🔄 v0.1.7 - 트랜잭션 및 오류 처리 (2024-08-06)

### ✨ 새로운 기능

#### 트랜잭션 지원
- **자동 트랜잭션**: 자동 트랜잭션 관리
- **오류 시 롤백**: 마이그레이션 오류 시 자동 롤백
- **커밋 제어**: 수동 커밋 제어 옵션
- **격리 수준**: 설정 가능한 트랜잭션 격리 수준

#### 향상된 오류 처리
- **상세한 오류 메시지**: 포괄적인 오류 정보
- **오류 복구**: 자동 오류 복구 메커니즘
- **재시도 로직**: 일시적 오류에 대한 자동 재시도
- **오류 로깅**: 상세한 오류 로깅 및 보고

## 📊 v0.1.6 - 성능 최적화 (2024-08-05)

### ✨ 새로운 기능

#### 성능 개선
- **배치 처리**: 대용량 데이터셋을 위한 최적화된 배치 처리
- **메모리 관리**: 개선된 메모리 사용 및 가비지 컬렉션
- **연결 풀링**: 향상된 연결 풀 관리
- **쿼리 최적화**: 자동 쿼리 최적화

#### 설정 옵션
```xml
<settings>
  <batchSize>1000</batchSize>
  <connectionPool>
    <min>5</min>
    <max>20</max>
    <acquireTimeout>60000</acquireTimeout>
  </connectionPool>
  <performance>
    <enableQueryOptimization>true</enableQueryOptimization>
    <enableBatchProcessing>true</enableBatchProcessing>
  </performance>
</settings>
```

## 🔧 v0.1.5 - 설정 개선 (2024-08-04)

### ✨ 새로운 기능

#### 향상된 설정
- **JSON 지원**: 완전한 JSON 설정 지원
- **환경 변수**: 환경 변수 치환
- **설정 검증**: 포괄적인 설정 검증
- **기본값**: 모든 설정에 대한 합리적인 기본값

#### 설정 예시
```json
{
  "databases": {
    "source": "sourceDB",
    "target": "targetDB"
  },
  "settings": {
    "batchSize": 1000,
    "logLevel": "INFO"
  },
  "queries": [
    {
      "id": "migrate_users",
      "sourceQuery": "SELECT * FROM users WHERE status = 'ACTIVE'",
      "targetTable": "users",
      "enabled": true
    }
  ]
}
```

## 📋 v0.1.4 - 문서 및 예시 (2024-08-03)

### ✨ 새로운 기능

#### 포괄적인 문서
- **사용자 매뉴얼**: 예시가 포함된 완전한 사용자 매뉴얼
- **API 문서**: 상세한 API 문서
- **설정 가이드**: 단계별 설정 가이드
- **문제 해결 가이드**: 일반적인 문제 및 해결책

#### 예시 파일
- **샘플 설정**: XML 및 JSON 예시 파일
- **데이터베이스 스크립트**: 샘플 데이터베이스 생성 스크립트
- **테스트 데이터**: 테스트용 샘플 데이터
- **마이그레이션 예시**: 실제 마이그레이션 예시

## 🔄 v0.1.3 - 핵심 마이그레이션 엔진 (2024-08-02)

### ✨ 새로운 기능

#### 핵심 마이그레이션 엔진
- **기본 마이그레이션**: 핵심 데이터 마이그레이션 기능
- **컬럼 매핑**: 자동 컬럼 매핑
- **데이터 타입 처리**: 포괄적인 데이터 타입 지원
- **오류 처리**: 기본 오류 처리 및 보고

#### 초기 기능
- XML 설정 지원
- 기본 SQL Server 연결
- 간단한 데이터 전송
- 기본 로깅

## 📊 v0.1.2 - 기반 (2024-08-01)

### ✨ 새로운 기능

#### 프로젝트 기반
- **프로젝트 구조**: 초기 프로젝트 구조
- **의존성**: 핵심 Node.js 의존성
- **기본 설정**: 초기 설정 시스템
- **문서**: 기본 프로젝트 문서

## 🔧 v0.1.1 - 초기 릴리스 (2024-07-31)

### ✨ 새로운 기능

#### 초기 릴리스
- **기본 기능**: 핵심 마이그레이션 도구 기능
- **SQL Server 지원**: SQL Server 데이터베이스 지원
- **Node.js 플랫폼**: Node.js 기반 구현
- **오픈 소스**: MIT 라이선스

---

**연락처**: sql2db.nodejs@gmail.com  
**웹사이트**: sql2db.com  
**라이선스**: MIT License